% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATSS_Design_Stage2.R
\name{ATSS_Design_Stage2}
\alias{ATSS_Design_Stage2}
\title{Adaptive Threshold and Sample Size Simon Design Two Stages}
\usage{
ATSS_Design_Stage2(p0, p1, r1_star, n1_star, n_double_star, alpha)
}
\arguments{
\item{p0}{Unacceptable efficacy rate}

\item{p1}{Desirable efficacy rate}

\item{r1_star}{Interim analysis design threshold in stage 1}

\item{n1_star}{The actual number of patients in stage 1}

\item{n_double_star}{The actual total number of patients in stages 1 and 2}

\item{alpha}{Original Type-I error rate}
}
\value{
a data frame includes the Adaptive Threshold and Sample Size Simon Design
interim analysis design adjusted first stage threshold r1*,
Adaptive Threshold and Sample Simon Design stage 2 new design adjusted second
stage threshold r*, actual number of patients in the first stage n1*,
actual total number of patients in stages 1 and 2 n**, attained Type-I error
and Power, Average sample size under null hypothesis EN(p0) and Probability
of early termination under null hypothesis PET(p0).
}
\description{
ATSS_Design_Stage2( ) provides an Adaptive Threshold and Sample Size Simon Design
(ATSS Simon) method for Simon's two stage design in oncology trials when the
realized sample sizes in the second stage is different from the planned
sample sizes in the second stage from interim analysis new design. Further
adjustment of the threshold at the second stage is needed. So, we update again
the second stage threshold r* to satisfy the type I error rate given
the interim analysis design first stage threshold r1* and actual two stages
sample sizes (n1*, n**).
}
\examples{
# Adaptive Threshold and Sample Size Simon Design two stages analysis case 1
ATSS_Design_Stage2(0.05, 0.20, 1, 20, 33, 0.10)
#                     r1* r* n1* n** Type I Power EN(p0) PET(p0)
# ATSS_Design_Stage2   1  3  20  33   0.07 0.888 23.434   0.736

# Adaptive Threshold and Sample Size Simon Design two stages analysis case 2
ATSS_Design_Stage2(0.10, 0.30, 2, 18, 24, 0.10)
#                   r1* r* n1* n** Type I Power EN(p0) PET(p0)
#ATSS_Design_Stage2   2  4  18  24   0.08 0.876 19.597   0.734

}
\references{
Yunhe Liu, & Haitao Pan. (2024). \emph{Clinical Trial Design Methods
for Managing Under- and Over-Enrollment in Simon's Two-Stage Design, Submitted.}
}
