% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniformSampling.R
\name{uniformSampling}
\alias{uniformSampling}
\title{Uniform sampling of the environmental space}
\usage{
uniformSampling(
  sdf,
  grid.res,
  n.tr = 5,
  n.prev = NULL,
  sub.ts = FALSE,
  n.ts = 5,
  plot_proc = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{sdf}{an sf object having point geometry given by the PC-scores values}

\item{grid.res}{(integer) resolution of the sampling grid. The resolution can be arbitrarily selected or defined using the \code{optimRes()} function.}

\item{n.tr}{(integer; optional) number of expected points given a certain prevalence threshold for the training dataset.}

\item{n.prev}{(double) sample prevalence}

\item{sub.ts}{(logical) sample the validation points}

\item{n.ts}{(integer; optional) number of  points for the testing dataset to sample in each cell of the sampling grid. sub.ts argument must be TRUE.}

\item{plot_proc}{(logical) plot progress of the sampling}

\item{verbose}{(logical) Print verbose}
}
\value{
An sf object with the coordinates of the sampled points both in the geographical and environmental space
}
\description{
\code{uniformSampling} performs the uniform sampling of observations within the environmental space. Note that \code{uniformSampling} can be more generally used to sample observations (not necessarily associated with species occurrence data) within bi-dimensional spaces (e.g., vegetation plots). Being designed with species distribution models in mind, \code{uniformSampling} allows collectively sampling observations for both the training and testing dataset (optional).
In both cases, the user must provide a number of observations that will be sampled in each cell of the sampling grid (\code{n.tr}: points for the training dataset; \code{n.ts}: points for the testing dataset). Note that the optimal resolution of the sampling grid can be found using the \code{optimRes} function.
}
