% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial_distribution.R
\name{binomial_}
\alias{binomial_}
\title{Binomial Distribution Function}
\usage{
binomial_(n = NULL, x = NULL, p = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{n}{Optional number of trials (not needed for interactive mode)}

\item{x}{Optional number of successes (not needed for interactive mode)}

\item{p}{Optional probability of success (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The binomial probability (for non-interactive mode)
}
\description{
This function calculates the binomial distribution probability.
}
\examples{
n <- 3
x <- 2
p <- 0.7

# Simple calculation
binomial_(n, x, p)

# Learning mode
binomial_(n, x, p, learn = TRUE)

# Interactive mode
if(interactive()){
binomial_(interactive = TRUE)
}

}
