% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.haz1ts.R
\name{plot.haz1ts}
\alias{plot.haz1ts}
\title{Plot method for a haz1ts object.}
\usage{
\method{plot}{haz1ts}(
  x,
  which_plot = c("hazard", "covariates"),
  plot_grid = NULL,
  plot_options = list(),
  ...
)
}
\arguments{
\item{x}{The output of the function \code{fit1ts}.}

\item{which_plot}{The type of plot required. Can be one of \code{"hazard"}
(default) or \code{"covariates"}.}

\item{plot_grid}{(optional) A named vector containing the parameters to build a new
grid of intervals over \code{s} for plotting the estimated hazard on a finer
grid. This must be of the form: \code{plot_grid = c(smin, smax, ds)},
where \code{smin}, \code{smax} are the minimum and maximum values desired for the
intervals over \code{s}, and \code{ds} is the distance between intervals over \code{s}. If
not specified, the plotting is done using the same B-splines basis as for
the estimation. The function will check if the parameters for the grid
provided by the user are compatible with those originally used to construct
the B-splines for estimating the model. If not, the grid will be adjusted
accordingly and a warning will be returned.}

\item{plot_options}{A list with all possible options for any of the plots:
\itemize{
\item \code{loghazard} A Boolean. Default is \code{FALSE}. If \code{FALSE} the function
returns a plot of the hazard curve, if \code{TRUE} the function returns
a plot of the log-hazard curve.
\item \code{log10hazard} A Boolean. Default is \code{FALSE}. If \code{TRUE} it returns a plot
of the log10-hazard curve.
\item \code{col} The color of the curve plotted. Default is \code{"black"}.
\item \code{add_CI} A Boolean. If \code{TRUE} (default) the confidence bands will be added.
\item \code{col_CI} The color for the confidence bands. The default is the same color
of the curve, with a 50\% transparancy level.
\item \code{main} The title of the plot.
\item \code{xlab} The label of the time axis (plotted on the x axis).
\item \code{ylab} The label of the y-axis (hazard, log-hazard or log10-hazard).
\item \code{xlim} A vector with two elements defining the limits of the time scale
on the x axis.
\item \code{ylim} A vector with two elements defining the limits of function plotted
on the y axis (hazard, log-hazard or log10-hazard).
\item \code{xmin} The minimum value on the x-axis.
\item \code{ymin} The minimum value on the y-axis.
\item \code{cex_main} The magnification to be used for the main title, default is 1.2 .
\item \code{cex_lab} The magnification to be used for the axis labels, default is 1 .
\item \code{HR} A Boolean. If \code{TRUE} the HRs with their CIs will be plotted.
Default is \code{FALSE} (plot the \code{beta} with their CIs).
\item \code{symmetric_CI} A Boolean. Default is \code{TRUE}. If a plot of the HRs is
required (\code{HR == TRUE}), then plot symmetrical Confidence Intervals,
based on the SEs for the HRs calculated by delta method.
If \code{FALSE}, then CIs are obtained by exponentiating the CIs for the betas.
\item \code{confidence} The level of confidence for the CIs. Default is .95 (alpha
= 0.05).
\item \code{col_beta} The color for the plot of the covariates' effects.
\item \code{pch} The symbol for plotting the point estimates.
}}

\item{\dots}{Further arguments to plot.}
}
\value{
A plot of the type required.
}
\description{
\code{plot.haz1ts()} is a plot method for objects of class \code{haz1ts}.
}
\examples{
## preparing data - no covariates
dt1ts <- prepare_data(data = reccolon2ts,
                      s_in = "entrys",
                      s_out = "timesr",
                      events = "status",
                      ds = 180)

## fitting the model with fit1ts() - default options

mod1 <- fit1ts(dt1ts)

plot(mod1)

}
