% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_bins.R
\name{make_bins}
\alias{make_bins}
\title{Construct bins over one or more time axes}
\usage{
make_bins(
  t_in = NULL,
  t_out = NULL,
  u = NULL,
  s_in = NULL,
  s_out,
  min_t = NULL,
  max_t = NULL,
  min_u = NULL,
  max_u = NULL,
  min_s = NULL,
  max_s = NULL,
  dt = NULL,
  du = NULL,
  ds
)
}
\arguments{
\item{t_in}{(optional) A vector of entry times on the time scale \code{t}.}

\item{t_out}{(optional) A vector of exit times on the time scale \code{t}.}

\item{u}{(optional) A vector of fixed-times at entry in the process.}

\item{s_in}{(optional) A vector of entry times on the time scale \code{s}.}

\item{s_out}{A vector of exit times on the time scale \code{s}.}

\item{min_t}{(optional) A minimum value for the bins over \code{t}.
If \code{NULL}, the minimum of \code{t_in} will be used.}

\item{max_t}{(optional) A maximum value for the bins over \code{t}.
If \code{NULL}, the maximum of \code{t_out} will be used.}

\item{min_u}{(optional) A minimum value for the bins over \code{u}.
If \code{NULL}, the minimum of \code{u} will be used.}

\item{max_u}{(optional) A maximum value for the bins over \code{u}.
If \code{NULL}, the maximum of \code{u} will be used.}

\item{min_s}{(optional) A minimum value for the bins over \code{s}.
If \code{NULL}, the minimum of \code{s_in} will be used.}

\item{max_s}{(optional) A maximum value for the bins over \code{s}.
If \code{NULL}, the maximum of \code{s_out} will be used.}

\item{dt}{(optional) A scalar giving the length of the intervals on the \code{t} time scale.}

\item{du}{(optional) A scalar giving the length of the intervals on the \code{u} axis.}

\item{ds}{A scalar giving the length of the intervals on the \code{s} time scale.}
}
\value{
A list with the following elements:
\itemize{
\item \code{bins_t} if \code{t_out} is provided, this is a vector of bins extremes for the time scale \code{t}
\item \code{midt} if \code{t_out} is provided, this is a vector with the midpoints of the bins over \code{t}
\item \code{nt} if \code{t_out} is provided, this is the number of bins over \code{t}
\item \code{bins_u} if \code{u} is provided, this is a vector of bins extremes for \code{u} axis
\item \code{midu} if \code{u} is provided, this is a vector with the midpoints of the bins over \code{u}
\item \code{nu} if \code{u} is provided, this is the number of bins over \code{u}
\item \code{bins_s} is a vector of bins extremes for the time scale \code{s}
\item \code{mids} is a vector with the midpoints of the bins over \code{s}
\item \code{ns} is the number of bins over \code{s}
}
}
\description{
\code{make_bins()} constructs the bins over the time axes and saves the extremes
of the bins in a vector.
}
\details{
It allows construction of bins over the time scales \code{t} and
\code{s} and/or over the fixed-time axis \code{u}. The time scale
\code{s} is always required. See also \code{\link[=prepare_data]{prepare_data()}} to conveniently
prepare individual data for the analysis with one, or two time scales.

A few words about constructing the grid of bins. There is no 'golden rule' or
optimal strategy for setting the number of bins over each time axis, or deciding
on the bins' width. It very much depends on the data structure, however, we
try to give some directions here. First, in most cases, more bins is better
than less bins. A good number is about 30 bins.
However, if data are scarce, the user might want to find a compromise between
having a larger number of bins, and having many bins empty.
Second, the chosen width of the bins (that is \code{du} and \code{ds}) does depend on
the time unit over which the time scales are measured. For example, if the time
is recorded in days, as in the example below, and several years of follow-up
are available, the user can split the data in bins of width 30 (corresponding
to about one month), 60 (about two months), 90 (about three months), etc.
If the time scale is measured in years, then appropriate width could be 0.25
(corresponding to a quarter of a year), or 0.5 (that is half year). However,
in some cases, time might be measure in completed years, as is often the case
for age. In this scenario, an appropriate bin width is 1.

Finally, it is always a good idea to plot your data first, and explore the range
of values over which the time scale(s) are recorded. This will give insight
about reasonable values for the arguments \code{min_s}, \code{min_u}, \code{max_s} and \code{max_u}
(that in any case are optional).
}
\examples{
# Make bins for colon cancer data by time at randomization and time since recurrence
bins <- make_bins(u = reccolon2ts$timer, s_out = reccolon2ts$timesr,
                 du = 30, ds = 30)
# Make bins for colon cancer data only over time since recurrence
bins <- make_bins(s_out = reccolon2ts$timesr, ds = 60)
}
