% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_cell_param.R
\name{write_cell_param}
\alias{write_cell_param}
\title{Write cell parameters}
\usage{
write_cell_param(
  Rasterparam,
  parameter,
  default = NULL,
  name = "Problem",
  verbose = FALSE
)
}
\arguments{
\item{Rasterparam}{A Raster object with the values for the parameter}

\item{parameter}{The name of the parameter to use}

\item{default}{The value of the default value for the parameter if
there is one, otherwise keep it as NULL}

\item{name}{The name of the output file}

\item{verbose}{Logical whether messages will be written while the
function is generating calculations, defaults to FALSE}
}
\value{
.dat file. This function is used for the side-effect of writing values to a file.
}
\description{
This function takes a Raster object, uses its values as a parameter and writes them to a .dat file. The file
will be written to the location specified by the \code{name} argument. If the file
already exists, it will be overwritten. The file format is plain text, with each
line terminated by a newline character.
}
\examples{

library(terra)

A <- TroublemakeR::Current |> terra::unwrap()
A <- A[[1]]

write_cell_param(Rasterparam = A, parameter = "Suitability", name = "Problem")

 write_cell_param(Rasterparam = A, parameter = "Carbon", default = 1,
 name = "Problem")

 write_cell_param(Rasterparam = A, parameter = "Cost", default = 0,
 name = "Problem")

 file.remove("Problem.dat")
}
