% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setClass.R
\docType{class}
\name{classTreeRingShape-class}
\alias{classTreeRingShape-class}
\title{class of TreeRingShape}
\description{
class of TreeRingShape
}
\section{Slots}{

\describe{
\item{\code{P_filename}}{character. file name of shape file (P) for tree ring points}

\item{\code{P_id.tag}}{character.   column name of id in shape file (P), default is 'id'}

\item{\code{P_ring.tag}}{character. column name of ring no.(ordinaly year,outermost=0) in shape file (P), default is 'ring'}

\item{\code{P}}{data.frame.         radial tree ring points (x,y,id,yr,r,deg)}

\item{\code{P00}}{numeric.          x,y coordinates c(px00,py00) of tree ring center point, ordinarily a pith in a disk, a point of id==0 in P}

\item{\code{n_id}}{numeric.         number of radial measurement points, length(unique(P$id))-1  (omit a original point id=0)}

\item{\code{YR_P}}{numeric.         total number of tree rings, unique(P$ring)}

\item{\code{L_filename}}{character. file name of shape file (L) for tree ring lines}

\item{\code{L_ring.tag}}{character. column name of ring no.(ordinaly year,outermost=0) in shape file (L), default is 'ring'}

\item{\code{L}}{list.               x,y coordinates of representative tree rings}

\item{\code{L_}}{data.frame.        x,y coordinates of representative tree rings}

\item{\code{YR_L}}{numeric.         cumulative tree rings number(year) from 0 (cambium layer) of L =dbf$ring, names(L)}

\item{\code{ln}}{numeric.           total number of  representative tree rings,  length(L)}

\item{\code{L2_filename}}{character. file name of shape file (L2) for tree ring lines interpolated}

\item{\code{L2}}{list.              x,y coordinates of representative + interpolated tree rings}

\item{\code{n_YR}}{numeric.        total number of representative + interpolated tree rings  = unique(P$yr), length(L2)}
}}

\examples{
 TR. <- new('classTreeRingShape')
 TR.
 slotNames(TR.)
 str(TR.)
}
