% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeRingsInterpolation.R
\name{TreeRingShape}
\alias{TreeRingShape}
\title{Construct a object (TR) of classTreeRingShape}
\usage{
TreeRingShape(
  P_filename,
  L_filename,
  L2_filename,
  P_id.tag = "id",
  P_ring.tag = "ring",
  L_ring.tag = "ring"
)
}
\arguments{
\item{P_filename}{file name of shape file (P) for tree ring points  (without extention)}

\item{L_filename}{file name of shape file (L) for tree ring lines  (without extention)}

\item{L2_filename}{file name of shape file (L2) for tree ring lines interpolated (without extention)}

\item{P_id.tag}{column name of id in shape file (P), default is 'id'}

\item{P_ring.tag}{column name of ring no.(ordinaly year,outermost=0) in shape file (L), default is 'ring'}

\item{L_ring.tag}{column name of ring no.(ordinaly year,outermost=0) in shape file (L), default is 'ring'}
}
\value{
generated new object from classTreeRingShape
}
\description{
Construct a object (TR) of classTreeRingShape
}
\examples{


test_TreeRingShape <- function(){
oldwd <- getwd()
on.exit(setwd(oldwd))
setwd(system.file("shp",package = "TreeRingShape"))

TR.<-TreeRingShape(
P_filename='Abies_277_h400_TreeRing_Points.shp',
L_filename='Abies_277_h400_TreeRing_Representative.shp',
L2_filename='Abies_277_h400_TreeRing.shp',
P_id.tag='id',P_ring.tag='ring',
L_ring.tag='ring')

 slotNames(TR.)
 str(TR.)
 Lplot(TR.@L2)
 return(TR.)
}

 TR. <- test_TreeRingShape()
 DiskInfo(TR.)

}
