% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterDiffGenes.R
\name{filter_diff_genes}
\alias{filter_diff_genes}
\title{Filter Differentially Expressed Genes}
\usage{
filter_diff_genes(
  data,
  p_val_col = "adj.P.Val",
  log_fc_col = "logFC",
  p_val_threshold = 0.05,
  log_fc_threshold = 1
)
}
\arguments{
\item{data}{A data frame containing gene expression data.}

\item{p_val_col}{Character string indicating the column name for p-values. Default is "adj.P.Val".}

\item{log_fc_col}{Character string indicating the column name for log fold change. Default is "logFC".}

\item{p_val_threshold}{Numeric threshold for filtering p-values. Default is 0.05.}

\item{log_fc_threshold}{Numeric threshold for filtering log fold change. Default is 1.0.}
}
\value{
A data frame with genes filtered by the specified criteria.
}
\description{
This function filters a data frame to identify genes with significant differential expression
based on specified thresholds for p-values and log fold change. It allows for flexible
input of column names for p-values and log fold change.
}
\examples{
# Create a sample data frame with p-values and log fold changes
sample_data <- data.frame(
  adj.P.Val = c(0.03, 0.06, 0.02, 0.07),
  logFC = c(1.5, 0.8, -1.2, 1.1),
  gene = c("Gene1", "Gene2", "Gene3", "Gene4")
)

# Use the filter_diff_genes function to filter significant genes
filtered_genes <- filter_diff_genes(sample_data)
print(filtered_genes)
}
