% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_bindings.R
\name{set_numeric_threshold}
\alias{set_numeric_threshold}
\title{Set a numeric cutoff}
\usage{
set_numeric_threshold(e, numeric_cutoff, stat, column = NULL)
}
\arguments{
\item{e}{A \code{count_layer} object}

\item{numeric_cutoff}{A numeric value where only values greater than or equal
to will be displayed.}

\item{stat}{The statistic to use when filtering out rows. Either 'n',
'distinct_n', or 'pct' are allowable}

\item{column}{If only a particular column should be used to cutoff values, it
can be supplied here as a character value.}
}
\value{
The modified Tplyr layer object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

In certain tables, it may be necessary to only include rows that meet numeric
conditions. Rows that are less than a certain cutoff can be suppressed from
the output. This function allows you to pass a cutoff, a cutoff stat(n,
distinct_n, pct, or distinct_pct) to supress values that are lesser than the
cutoff.
}
\examples{
mtcars \%>\%
tplyr_table(gear) \%>\%
  add_layer(
    group_count(cyl) \%>\%
      set_numeric_threshold(10, "n") \%>\%
      add_total_row() \%>\%
      set_order_count_method("bycount")
  )
}
