% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chem_correction.R
\name{chem_correction}
\alias{chem_correction}
\title{Corrections of melting temperature with chemical substances}
\usage{
chem_correction(
  DMSO = 0,
  fmd = 0,
  DMSOfactor = 0.75,
  fmdmethod = c("concentration", "molar"),
  fmdfactor = 0.65,
  ptGC
)
}
\arguments{
\item{DMSO}{Percent DMSO}

\item{fmd}{Formamide concentration in percentage (fmdmethod="concentration") or molar (fmdmethod="molar").}

\item{DMSOfactor}{Coefficient of Tm decreases per percent DMSO. Default=0.75 von Ahsen N (2001) <PMID:11673362>. Other published values are 0.5, 0.6 and 0.675.}

\item{fmdmethod}{"concentration" method for formamide concentration in percentage and "molar" for formamide concentration in molar}

\item{fmdfactor}{Coefficient of Tm decrease per percent formamide. Default=0.65. Several papers report factors between 0.6 and 0.72.}

\item{ptGC}{Percentage of GC(\%).}
}
\description{
Corrections coefficient of melting temperature with DMSO and formamide and these corrections are rough approximations.
}
\details{
fmdmethod = "concentration"

Correction = - factor*percentage_of_formamide

fmdmethod = "molar"

Correction = (0.453*GC/100 - 2.88) x formamide
}
\examples{
chem_correction(DMSO=3)
chem_correction(fmd=1.25, fmdmethod="molar", ptGC=50)

}
\references{
von Ahsen N, Wittwer CT, Schutz E , et al. Oligonucleotide melting temperatures under PCR conditions: deoxynucleotide Triphosphate and Dimethyl sulfoxide concentrations with comparison to alternative empirical formulas. Clin Chem 2001, 47:1956-C1961.
}
\author{
Junhui Li
}
