% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-bootstrap-p.R
\name{bootstrap_p_augment}
\alias{bootstrap_p_augment}
\title{Augment Bootstrap P}
\usage{
bootstrap_p_augment(.data, .value, .names = "auto")
}
\arguments{
\item{.data}{The data being passed that will be augmented by the function.}

\item{.value}{This is passed \code{\link[rlang:enquo]{rlang::enquo()}} to capture the vectors you want
to augment.}

\item{.names}{The default is "auto"}
}
\value{
A augmented tibble
}
\description{
Takes a numeric vector and will return the ecdf probability.
}
\details{
Takes a numeric vector and will return the ecdf probability of that vector.
This function is intended to be used on its own in order to add columns to a
tibble.
}
\examples{
x <- mtcars$mpg
tidy_bootstrap(x) |>
  bootstrap_unnest_tbl() |>
  bootstrap_p_augment(y)

}
\seealso{
Other Augment Function: 
\code{\link{bootstrap_density_augment}()},
\code{\link{bootstrap_q_augment}()}

Other Bootstrap: 
\code{\link{bootstrap_density_augment}()},
\code{\link{bootstrap_p_vec}()},
\code{\link{bootstrap_q_augment}()},
\code{\link{bootstrap_q_vec}()},
\code{\link{bootstrap_stat_plot}()},
\code{\link{bootstrap_unnest_tbl}()},
\code{\link{tidy_bootstrap}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Augment Function}
\concept{Bootstrap}
