% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode.R
\name{recode}
\alias{recode}
\title{Recode variables.}
\usage{
recode(var = var, vals = c(1, 2, 3, 4, 5), ct = c(5, 4, 3, 2, 1),
  cat = FALSE)
}
\arguments{
\item{var}{A variable/column of a data matrix/ data frame containing data to be recoded.}

\item{vals}{A vector containing the original scores. If cat is TRUE, these are thresholds.}

\item{ct}{A vector containing the desired scores.}

\item{cat}{Logical. should the data be categorized?

### Outputs ----}
}
\value{
Returns a vector with the recoded input values.
}
\description{
Recode variables.
}
\details{
This function is a simple recode function. It is possible to recode any value to any other value, as long as the class of values within a vector are equal. If an interval of numerical values should be categorized, for N categories, N-1 thresholds must be given. The first N-1 categories are constructed by using all values that are smaller or equal (<=) than the thresholds, the last category is constructed to be all values larger than the last threshold.
}
\examples{
#numerical
v <- rep(c(1:5),10)
v_r <- recode(v, c(1:5), c(5:1))

# character
v <- rep(c('a','b','d','e'),10)
v_r <- recode(v, c('a','b','d','e'), c('apple','1','dummy',TRUE))

# interval
set.seed(1)
v <- sample(runif(20,0,6))

# recode x <= 1.3 into 1
# recode x <= 2.6 into 2
# recode x <= 3.9 into 3
# recode x <= 5.2 into 4
# recode x > 5.1 into 5
v_r <- recode(v,c(1.3,2.6,3.9,5.2),c(1:5),cat=TRUE)

}
\author{
Markus Thomas Jansen
}
