% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.scores.R
\name{get.scores}
\alias{get.scores}
\title{Estimate factor scores based on Genuine Likelihood}
\usage{
get.scores(dat, blocks, itf, fit, alg = mvtnorm::TVPACK(), log = TRUE, mp,
  sp, serr = TRUE, sv = NULL, blocks_ul = NULL, mplus = FALSE, ...)
}
\arguments{
\item{dat}{A data.frame or matrix defining holding the binary coded and named
response data.}

\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}

\item{itf}{A vector defining the items-to-factor relation. For example
`c(1,1,1,2,2,2)` defines six items, the first three correspond to factor 1,
the second three correspond to factor 2.}

\item{fit}{The fit object. In case of Mplus, this is the path to the Mplus output file. In case of lavaan this is the lavaan Object.}

\item{alg}{The algorithm to use for numerical integration. See ?mvtnorm::pmvnorm.}

\item{log}{logical. Should the log transformed results be returned. Defaults to TRUE.}

\item{mp}{The means of prior distribution. Defaults to multivariate normal with means 0 and vars 1}

\item{sp}{The vars of prior distribution. Defaults to multivariate normal with means 0 and vars 1}

\item{serr}{Logical. Should the standard errors be returned. Defaults to TRUE.}

\item{sv}{Starting values. Defaults to NULL.}

\item{blocks_ul}{Similar to `blocks`, but only with the unlinked design. Useful
for comparison with other functions based on R.}

\item{mplus}{Logical. Are results read from mplus? Defaults to FALSE.}

\item{...}{other arguments passed by get.scores for optim.}
}
\value{
The result is a list with the factor scores and the standard errors per person and factor.
}
\description{
This function estimates factor scores based on genuine likelihood (Yousfi, 2019).
}
\details{
The function estimates factor scores based on the Thurstonian IRT model
and based on genuine likelihood proposed by Yousfi (2019). The function allows
for the estimation of factor scores under all block designs, limited only by 
numerical integration procedures. For items per block between 5 and 20 use 
`alg=mvtnorm::Miwa()`. Additionally, all model types can be performed with all
types of forced choice designs (full, block, partially linked block, linked
block). For an overview and review see Jansen and Schulze (2023a,2023b).

The standard naming procedure ixiy, for the comparison of items x and y.
}
\examples{


# read and save data set FC
data(FC12)

# set seed and define blocks
blocks <- matrix(c(5,2,1,4,7,6,3,8,10,12,9,11), ncol = 3)

# define the item-to-factor relation
itf <- rep(1:3,4)

# Create and run syntax
\donttest{fit <- fit.lavaan(blocks, itf, 'irt', FC, estimator = 'ULSMV')

# get scores for the first two respondents
ests <- get.scores(dat=as.matrix(FC)[1:2,],itf=itf, blocks=blocks,
fit = fit,mp=rep(0,max(itf)), 
sp=diag(1,max(itf)),estimator="MAP",sv=NULL, alg=mvtnorm::Miwa(),log=TRUE, mplus=FALSE)}

}
\references{
Maydeu-Olivares, A., & Böckenholt, U. (2005). Structural equation modeling of paired-comparison and ranking data. \emph{Psychological Methods}, \emph{10}(3), 285-304. \doi{10.1037/1082-989X.10.3.285}

Maydeu-Olivares, A., & Brown, A. (2010). Item response modeling of paired comparison and ranking data. \emph{Multivariate Behavioural Research}, \emph{45}(6), 935-974. \doi{10.1080/00273171.2010.531231}
 
Jansen, M. T., & Schulze, R. (2023a). \emph{Linear factor analytic Thurstonian forced-choice models: Current status and issues}. Educational and Psychological Measurement.

Jansen, M. T., & Schulze, R. (2023b, in review). \emph{The Thurstonian linked block design: Improving Thurstonian modeling for paired comparison and ranking data}. 

Yousfi, S. (2019). Person Parameter Estimation for IRT Models of Forced-Choice Data: Merits and Perils of Pseudo-Likelihood Approaches. In: Wiberg, M., Molenaar, D., González, J., Böckenholt, U., Kim, JS. (eds) \emph{Quantitative Psychology}. IMPS 2019. Springer Proceedings in Mathematics & Statistics, vol 322. Springer, Cham. \doi{10.1007/978-3-030-43469-4_3}.
}
