% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocksort.R
\name{blocksort}
\alias{blocksort}
\title{Sorts the blocks in ascending numbering}
\usage{
blocksort(blocks)
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows 
must be the number of blocks, each row represents a block and contains the 
item numbers. The number of columns represent the number of items per block.}
}
\value{
Returns a matrix consisting of the blocks where all items per blocks
are sorted in ascending order.
}
\description{
This function sorts all items in a block into ascending order.
}
\examples{

# Define 30 items divided by ten triplets as blocks
blocks <- matrix(c(1:30), ncol = 3)

# sort the blocks
blocksort(blocks)

}
