% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Excel2int.R
\name{hexavigesimalExcel}
\alias{hexavigesimalExcel}
\alias{Excel2int}
\alias{Excel2C}
\title{Hexavigesimal (Base 26L) and Excel Columns}
\usage{
Excel2int(x)

Excel2C(x)
}
\arguments{
\item{x}{\link[base]{character} scalar or \link[base]{vector},
which consists of (except missingness)
only letters \code{A} to \code{Z} and \code{a} to \code{z}.}
}
\value{
Function \link{Excel2int} returns an
\link[base]{integer} \link[base]{vector}.

Function \link{Excel2C} returns a
\link[base]{character} \link[base]{vector}.
}
\description{
Convert between decimal, hexavigesimal in C-style, and hexavigesimal in Excel-style.
}
\details{
Convert between decimal, hexavigesimal in C-style, and hexavigesimal in Excel-style.

\tabular{lrrrrrrrrrr}{
Decimal \tab 0 \tab 1 \tab 25 \tab 26 \tab 27 \tab 51 \tab 52 \tab 676 \tab 702 \tab 703 \cr
Hexavigesimal; C \tab \code{0} \tab \code{1} \tab \code{P} \tab \code{10} \tab \code{11} \tab \verb{1P} \tab \code{20} \tab \code{100} \tab \code{110} \tab \code{111} \cr
Hexavigesimal; Excel \tab \code{0} \tab \code{A} \tab \code{Y} \tab \code{Z} \tab \code{AA} \tab \code{AY} \tab \code{AZ} \tab \code{YZ} \tab \code{ZZ} \tab \code{AAA} \cr
}

Function \link{Excel2C} converts
from hexavigesimal in Excel-style
to hexavigesimal in C-style.

Function \link{Excel2int} converts
from hexavigesimal in Excel-style
to decimal, using function \link{Excel2C} and \link[base]{strtoi}.
}
\examples{
int1 = c(NA_integer_, 1L, 25L, 26L, 27L, 51L, 52L, 676L, 702L, 703L)
Excel1 = c(NA_character_, 'A', 'Y', 'Z', 'AA', 'AY', 'AZ', 'YZ', 'ZZ', 'AAA')
C1 = c(NA_character_, '1', 'P', '10', '11', '1P', '20', '100', '110', '111')
stopifnot(identical(int1, Excel2int(Excel1)), identical(int1, strtoi(C1, base = 26L)))

int2 = c(NA_integer_, 1L, 4L, 19L, 37L, 104L, 678L)
Excel2 = c(NA_character_, 'a', 'D', 's', 'aK', 'cZ', 'Zb')
stopifnot(identical(int2, Excel2int(Excel2)))
Excel2C(Excel2)

head(swiss[Excel2int('A')])
}
\references{
\url{http://mathworld.wolfram.com/Hexavigesimal.html}
}
\seealso{
\link[base]{as.hexmode}
}
