% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{continuous_config}
\alias{continuous_config}
\title{Continuous Variable Configuration for Theseus Plot}
\usage{
continuous_config(
  n = 10L,
  pretty = TRUE,
  split = c("count", "width", "rate"),
  breaks = NULL
)
}
\arguments{
\item{n}{integer. Number of bins to create for a continuous variable.}

\item{pretty}{logical. If TRUE, use pretty breaks for bin edges.}

\item{split}{string. Method for binning continuous variables. Options are:
\describe{
  \item{\code{"count"}}{divide the variable into bins with roughly equal number of observations.}
  \item{\code{"width"}}{divide the range of the variable into equal-width bins.}
  \item{\code{"rate"}}{divide based on differences in outcome rates between bins.}
}}

\item{breaks}{numeric vector specifying custom break points.}
}
\value{
A list containing binning parameters (\code{n}, \code{pretty},
  \code{split}, \code{breaks}) to be used in plotting or contribution
  calculations for continuous variables.
}
\description{
The \code{continuous_config()} function creates a configuration object for
handling continuous variables in Theseus plots. It controls how continuous
data is binned into discrete categories for contribution calculations and
visualization.
}
\examples{
library(TheseusPlot)
continuous_config(n = 5, pretty = FALSE, split = "rate")

}
