% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResponseFun.r
\name{ResponseFun}
\alias{ResponseFun}
\title{Response Function Imputation (RF)}
\usage{
ResponseFun(test.data, Mvalue = "NA", max.score = 1, round.decimal = 0)
}
\arguments{
\item{test.data}{Test data set (a data frame or a matrix) containing missing responses. 
Missing values are coded as NA or other values (e.g., 8, 9).#'}

\item{Mvalue}{Missing response indicators in the data (e.g. "NA", "8", "9", etc.). Mvalue="NA" by default.}

\item{max.score}{The max possible response value in test data (the lowest response value should be 0). 
By default max.score=1 (i.e.,binary test data). max.score = 2 if the response categories are (0, 1, 2), etc.}

\item{round.decimal}{The number of digits or decimal places for the imputed value. The default value is 0.}
}
\value{
A data frame with all missing responses imputed with response function.
}
\description{
This function imputes for all missing responses using the response function imputation 
(Sijtsma and van der Ark, 2003 <doi: 10.1207/s15327906mbr3804_4>).
}
\examples{
 
        ResponseFun(test.data, Mvalue="NA",max.score=1,round.decimal=0)
}
\references{
{
Sijtsma, K., & Van der Ark, L. A. (2003).
"Investigation and treatment of missing item scores in test and questionnaire data."
 Multivariate Behavioral Research, 38(4), 505-528. DOI: 10.1207/s15327906mbr3804_4.
}
}
