% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_timeseries.R
\name{plot_timeseries}
\alias{plot_timeseries}
\title{Plot time series}
\usage{
plot_timeseries(tendril, term = NULL)
}
\arguments{
\item{tendril}{An object of class Tendril, as made by Tendril()}

\item{term}{A character vector describing the value or values of Term to
select; defaults to \code{NULL} which corresponds to all values}
}
\description{
Plot time series of net events on a second treatment arm
}
\examples{
# generate data using Tendril()
data <- Tendril(
  mydata = TendrilData,
  rotations = Rotations,
  AEfreqThreshold = 9,
  Tag = "Comment",
  Treatments = c("placebo", "active"),
  Unique.Subject.Identifier = "subjid",
  Terms = "ae",
  Treat = "treatment",
  StartDay = "day",
  SubjList = SubjList,
  SubjList.subject = "subjid",
  SubjList.treatment = "treatment"
)

# do plot
plot_timeseries(data, term="AE33")
plot_timeseries(data, term=c("AE33","AE40"))
plot_timeseries(data, term=NULL)
}
