% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TendrilPerm.R
\name{TendrilPerm}
\alias{TendrilPerm}
\title{Tendril permutations}
\usage{
TendrilPerm(tendril, PermTerm, n.perm = 100, perm.from.day = 1,
  pi.low = 0.1, pi.high = 0.9)
}
\arguments{
\item{tendril}{an object of class tendril as produced by Tendril()}

\item{PermTerm}{the name of the type of event (tendril) to calculate permutations on}

\item{n.perm}{the number of permutations. Default 100}

\item{perm.from.day}{the starting day for the permutation calculations. Default 1}

\item{pi.low}{percentile low value. Default 0.1}

\item{pi.high}{percentile high value. Default 0.9}
}
\value{
The function return an object of class TendrilPerm containing all the input data and a dataframe of permutation results. Use:

data$perm.data

and

data$tendril.pi

and

data$tendril

to access the permutations, percentiles dataframes, and tendril data respectively
}
\description{
Function to compute the permutations of one specified tendril, starting from a specific day.
Permutations are simulated under the null hypothesis. Thus, on average, there will be an equal number of events on each treatment arm.
}
\details{
Make permutation analysis to a specific type of event, as specified in PermTerm.
}
\examples{
# Create tendril
tendril <- Tendril(mydata = TendrilData,
  rotations = Rotations,
  AEfreqThreshold = 9,
  Tag = "Comment",
  Treatments = c("placebo", "active"),
  Unique.Subject.Identifier = "subjid",
  Terms = "ae",
  Treat = "treatment",
  StartDay = "day",
  SubjList = SubjList,
  SubjList.subject = "subjid",
  SubjList.treatment = "treatment"
)

# Compute permutations
perm.data <- TendrilPerm(tendril = tendril,
  PermTerm="AE40",
  n.perm = 200,
  perm.from.day = 1)

# Plot results
plot(perm.data)
plot(perm.data, percentile = TRUE)
}
