% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tejapi.R
\name{Tejapi}
\alias{Tejapi}
\title{Retrieves Data from the Tejapi Datatable endpoint}
\usage{
Tejapi(datatable_code, paginate = FALSE, ...)
}
\arguments{
\item{datatable_code}{Datatable code on Tejapi specified as a string.}

\item{paginate}{When set to TRUE, fetches up to 1,000,000 rows of data}

\item{...}{Additional named values that are interpreted as Tejapi API parameters.}
}
\value{
Returns a data.frame.
}
\description{
Retrieves Data from the Tejapi Datatable endpoint
}
\details{
Set your \code{api_key} with \code{Tejapi.api_key} function. For instructions on finding your api key go to \url{https://api.tej.com.tw}
}
\examples{
\dontrun{
Tejapi.datatable('TWN/AIND', paginate=TRUE)
}
}
\seealso{
\code{\link{Tejapi.api_key}}
}
