% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tex_group_by_char.R
\name{tex_group_by_char}
\alias{tex_group_by_char}
\title{TeX group by character position}
\usage{
tex_group_by_char(tex_lines, optional = FALSE)
}
\arguments{
\item{tex_lines}{Character vector of a document LaTeX.}

\item{optional}{If \code{FALSE} (the default), the groups are taken with respect to braces. 
If \code{TRUE}, square brackets are used (perhaps not associated with a command).}
}
\value{
A list the same length as \code{lines}. Each element an integer vector indicating the 
TeX group at that position. 

For positions \strong{at} braces the \strong{upcoming} group is returned. 
So \code{a{b}} should return \code{0 1 1 0} (in its first element).
}
\description{
Opening a brace increases the 'group' in TeX. For example, in \code{a{bc}{d{e}}}
\code{a} is in group 0, \code{bc} in group 1 as is \code{d} and \code{e} is in group 2.
}
\examples{
tex_group_by_char("a{bc}{d{e}}")
}
