% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_report.R
\name{split_report}
\alias{split_report}
\title{Split report into include-able files}
\usage{
split_report(
  Report.tex,
  include = TRUE,
  subdir = "tex",
  use.chapter.title = TRUE,
  out.tex = Report.tex
)
}
\arguments{
\item{Report.tex}{File to split.}

\item{include}{Should \code{\\include} or \code{\\input} be used? If \code{TRUE}, the default, \code{\\include} is used.}

\item{subdir}{What directory should each chapter file be written in? By default, a subdirectory of the folder containing \code{Report.tex}, called \code{tex}, is used.}

\item{use.chapter.title}{Should the chapter title be used to name the chapter files? If \code{TRUE}, the default, the title is used (with characters outside \code{[a-zA-Z0-9]} replaced by spaces), prefixed by the chapter number; otherwise, just the chapter number is used.}

\item{out.tex}{The new root file. By default, same as \code{Report.tex}.}
}
\description{
Split report into include-able files
}
