% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_comp.R
\name{forecast_comp}
\alias{forecast_comp}
\title{Four standard forecasts of a competition dataset}
\usage{
forecast_comp(the_series, tests = list(the_series$h), plot = FALSE, ...)
}
\arguments{
\item{the_series}{a list of class \code{Mdata} eg from the \code{Mcomp} or \code{Tcomp} package.  Crucially, must include elements \code{x} (the training set), \code{xx} (the test set) and \code{h} (the forecast horizon)}

\item{tests}{a list of the forecast horizons over which to return the MAPE and MASE, passed to \code{accuracy}}

\item{plot}{whether or not to draw basic plot of the four forecast model}

\item{...}{other parameters to pass to \code{plot.forecast()}}
}
\value{
A data frame of eight rows and \code{length(tests) + 1} columns with first column as method and each other column containing the 
Mean Absolute Percentage Error (MAPE, first four rows) and Mean Absolute Scaled Error (MASE, final four rows) at the horizon 
indicated by the column name
}
\description{
Applies four modelling strategies (ARIMA, ETS, Theta and naive or seasonally naive) to a dataset
with class \code{Mdata}, returns accuracy statistics and (optionally) a summary graphic
}
\details{
This is just a convenience function for fitting four different standard time series forecasts to an object from an 
M competition or the tourism competition.  Mainly of interest to analysis wishing to re-produce published results or create 
a benchmark against which other methods can be compared.
}
\examples{
forecast_comp(tourism$Y18, test = list(1, 2, 3, 4, 1:2, 1:4), plot = TRUE)
forecast_comp(tourism$Q4, test = list(1, 2, 3, 4, 5, 6, 7, 8, 1:4, 1:8), plot = FALSE)
}
