% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tarrif.summary.r
\name{summary.tariff}
\alias{summary.tariff}
\title{Summary of the results obtained from Tariff algorithm}
\usage{
\method{summary}{tariff}(object, top = 5, id = NULL, ...)
}
\arguments{
\item{object}{fitted object from \code{\link{tariff}}}

\item{top}{number of top CSMF to show}

\item{id}{the ID of a specific death to show}

\item{...}{not used}
}
\description{
This function prints the summary message of the fitted results.
}
\examples{

\donttest{
data("RandomVA3")
test <- RandomVA3[1:200, ]
train <- RandomVA3[201:400, ]
allcauses <- unique(train$cause)
fit <- tariff(causes.train = "cause", symps.train = train, 
			symps.test = test, causes.table = allcauses)
correct <- which(fit$causes.test[,2] == test$cause)
accuracy <- length(correct) / dim(test)[1]
summary(fit)
summary(fit, top = 10)
summary(fit, id = "p849", top = 3)
}

}
\keyword{Tariff}
