% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_TailID.R
\name{plot_TailID}
\alias{plot_TailID}
\title{Saves the plots corresponding to the TailID detection}
\usage{
plot_TailID(output_dir, sample, pm_max, pm_min, pc_max, pc_min, conf_level)
}
\arguments{
\item{output_dir}{Path to save the plots.}

\item{sample}{A numeric vector.}

\item{pm_max}{A number between 0 and 1 indicating the threshold of maximum extreme values to consider.}

\item{pm_min}{A number between 0 and 1 indicating the threshold of minimum extreme values to consider.}

\item{pc_max}{A number between pm_max and 1 indicating the threshold of maximum sensitive points to consider.}

\item{pc_min}{A number between pm_min and 1 indicating the threshold of minimum sensitive points to consider.}

\item{conf_level}{A number between 0 and 1 indicating the confidence level for the detection.}
}
\value{
A vector of indices corresponding to the detected sensitive points.
}
\description{
This function saves the plots corresponding to the TailID detection, which includes: targeted candidates plot, shape variation plot, and inconsistent detected points.
}
\examples{
output_dir <- file.path(tempdir(), "output")
if (dir.exists(output_dir) || dir.create(output_dir, recursive = TRUE)) {
  plot_TailID(output_dir, rnorm(1000), 0.85, 0.85, 0.999, 0.999, 0.95)
}
if (dir.exists(output_dir) || dir.create(output_dir, recursive = TRUE)) {
  plot_TailID(output_dir, c(rnorm(10^3, 10, 1), rnorm(10, 20, 3)), 0.85, 0.85, 0.99, 0.99, 0.99999)
}
}
