% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_ttr.R
\name{get_parms}
\alias{get_parms}
\title{get_parms: Pack parameters in an easily accessible list}
\usage{
get_parms(par, Data, no.structure = FALSE)
}
\arguments{
\item{par}{A numeric vector of parameters as supplied by an external parameter estimation algorithm, e.g. LaplacesDemon or DEoptim}

\item{Data}{data object as returned by the \code{make_data()} function}

\item{no.structure}{If 'TRUE', only run \code{interval_parms()} and \code{unname()} the result, this is convenient when using LaplacesDemon.}
}
\value{
A list containing a vector of the alpha parameters and an array of dimension (nbeta, nspecies)
        where nbeta is the number of beta parameters and nspecies is the number of species, containing the
        beta parameters per species
}
\description{
This function takes a numeric vector of all process model parameters and returns a 
representation that is human readable and can be used by \code{run_ttr()}
}
