% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slidingWindows.r
\name{slidingWindows-deprecated}
\alias{slidingWindows-deprecated}
\alias{slidingWindows}
\title{Generating sliding windows of data}
\usage{
slidingWindows(timeseries, swSize)
}
\arguments{
\item{timeseries}{A vector or univariate time series from which the sliding
windows are to be extracted.}

\item{swSize}{Numeric value of the required size (length) of each sliding
window.}
}
\value{
A numeric matrix of size (length(\code{timeseries})-\code{swSize}+1)
by \code{swSize}, where each line is a sliding window.
}
\description{
The function extracts all possible subsequences (of the same length) of a
time series (or numeric vector), generating a set of sliding windows of
data, often used to train machine learning methods.
}
\details{
The function returns all (overlapping) subsequences of size \code{swSize} of
\code{timeseries}.
}
\references{
Lampert, C. H., Blaschko, M. B., and Hofmann, T. (2008). Beyond
sliding windows: Object localization by efficient subwindow search. In
Computer Vision and Pattern Recognition, 2008. CVPR 2008. IEEE Conference
on, pages 1-8. IEEE.

Keogh, E. and Lin, J. (2005). Clustering of time series subsequences is
meaningless: Implications for previous and future research. Knowledge and
Information Systems, 8(2):154-177.
}
\seealso{
\code{\link{TSPred-deprecated}}
}
\author{
Rebecca Pontes Salles
}
\keyword{internal}
\keyword{series}
\keyword{sliding}
\keyword{time}
\keyword{windows}
