% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sMAPE.R
\name{sMAPE}
\alias{sMAPE}
\title{sMAPE error of prediction}
\usage{
sMAPE(actual, prediction)
}
\arguments{
\item{actual}{A vector or univariate time series containing actual values
for a time series that are to be compared against its respective
predictions.}

\item{prediction}{A vector or univariate time series containing time series
predictions that are to be compared against the values in \code{actual}. %%
~~Describe \code{forecast} here~~}
}
\value{
A numeric value of the sMAPE error of prediction.
}
\description{
The function calculates the sMAPE error between actual and predicted values.
}
\examples{

data(SantaFe.A,SantaFe.A.cont)
pred <- marimapred(SantaFe.A,n.ahead=100)
sMAPE(SantaFe.A.cont[,1], pred)

}
\references{
Z. Chen and Y. Yang, 2004, Assessing forecast accuracy measures,
Preprint Series, n. 2004-2010, p. 2004-10.  %% ~put references to the
literature/web site here ~
}
\seealso{
\code{\link{MAPE}}, \code{\link{MSE}}, \code{\link{NMSE}},
\code{\link{MAXError}} ~
}
\author{
Rebecca Pontes Salles
}
\keyword{SMAPE}
\keyword{error}
\keyword{prediction}
