% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_rpart.R
\name{rpart_nodes}
\alias{rpart_nodes}
\title{rpart_nodes}
\usage{
rpart_nodes(tree)
}
\arguments{
\item{tree}{An rpart.object returned from call to rpart().}
}
\value{
A data.frame containing the nodes of a parsed tree.
}
\description{
Extract node information from an rpart.object.
}
\details{
Information about nodes and splits returned in an rpart.object
is contained in strings printed to the console. This function parses those
strings and populates a data.frame.
}
\examples{
requireNamespace( "rpart", quietly = TRUE )
## Generate example data containing response, treatment, and covariates
N <- 50
continuous_response = runif( min = 0, max = 20, n = N )
binary_response <- sample( c('A','B'), size = N, prob = c(0.5,0.5),
                           replace = TRUE )
trt <- sample( c('Control','Experimental'), size = N, prob = c(0.4,0.6),
               replace = TRUE )
X1 <- runif( N, min = 0, max = 1 )
X2 <- runif( N, min = 0, max = 1 )
X3 <- sample( c(0,1), size = N, prob = c(0.2,0.8), replace = TRUE )
X4 <- sample( c('A','B','C'), size = N, prob = c(0.6,0.3,0.1), replace = TRUE )

## Fit an rpart model with continuous response (i.e. regression)
fit1 <- rpart::rpart( continuous_response ~ trt + X1 + X2 + X3 + X4 )
fit1

## Parse the results into a new data.frame
ex1 <- rpart_nodes( fit1 )
ex1

## Fit an rpart model with binary response (i.e. classification)
fit2 <- rpart::rpart( binary_response ~ trt + X1 + X2 + X3 + X4 )
fit2
}
\seealso{
\link[rpart]{rpart}, \link[rpart]{rpart.object}
}
