% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPMplt.R
\name{TPM3dplt}
\alias{TPM3dplt}
\title{Plot 3d thermal processing-maps}
\usage{
TPM3dplt(x, dvs = 5, etaclr = "heat", xiclr = "cm")
}
\arguments{
\item{x}{Regression results from modeling functions such as \code{\link[TPMplt:SVRModel]{SVRModel}}.}

\item{dvs}{A positive integer to set the divisions for x, y and z labels in two 3d surface plots. The default value is 5.}

\item{etaclr}{Colour control for eta. Optional value are "rainbow", "heat", "terrain", "topo" and "cm". "heat" is default value.}

\item{xiclr}{Colour control for xi. Optional value are "rainbow", "heat", "terrain", "topo" and "cm". "cm" is default value.}
}
\value{
Two 3d surface plots: the left one denotes power dissipation efficiency factor eta, while the right one is for rheological stability
xi. A zero plane, z=0, for xi value is added in the right plots for determining unstable region.
}
\description{
Return a 3d thermal process result consisted of 3d surfaces for power dissipation efficiency eta and rheological stability coefficient
xi respectively.
}
\examples{
epstable <- epsExtract(TPMdata, 0.7, 2, 3)
DMM <- DMMprocess(epstable)
PLTbd <- SVRModel(DMM)
TPM3dplt(PLTbd)
}
\keyword{PLTbuilder}
\keyword{Processing-map}
