% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_model_tou.R
\name{draw.model.tou}
\alias{draw.model.tou}
\title{A plot with the experimental data and the Transformed
Ornstein-Uhlenbeck (TOU) model.}
\usage{
draw.model.tou(x, time.unit = NULL, adsorption.unit = NULL)
}
\arguments{
\item{x}{a tou object.}

\item{time.unit}{an optional label indicating the unit name for the time, the
allowed labels are "seconds", "minutes" and "hours".}

\item{adsorption.unit}{a label indicating for unit name for the adsorption,
the allowed labels are "mg/g" and "mg/mmol".}
}
\value{
a plot with the experimental data and the fitted TOU model.
}
\description{
Plots the experimental data and the fitted TOU model.
}
\examples{

# an example with one trajectory of experimental adsorption
observed.time <- c(0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 150, 200,
                   250, 300)
observed.values <- c(0, 1.684, 2.341, 2.581, 2.842, 2.890, 2.959, 3.042,
                     3.083, 3.043, 3.017, 2.954, 2.996, 2.886, 2.844)
observed.process <- cbind(observed.time, observed.values)
# fitting the model without any fixed parameters
result <- fit.model.tou(w=observed.process)
# default units time in minutes and default units adsorption in mg/g
draw.model.tou(result)
# changing units time to seconds and units adsorption to mg/mmol
draw.model.tou(result, time.unit="seconds", adsorption.unit="mg/mmol")

observed.time <- c(0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 150, 200,
                   250, 300)
observed.values.1 <- c(0, 1.684, 2.341, 2.581, 2.842, 2.890, 2.959, 3.042,
                       3.083, 3.043, 3.017, 2.954, 2.996, 2.886, 2.844)
observed.values.2 <- c(0, 1.618, 2.217, 2.571, 2.763, 2.841, 2.866, 2.898,
                       2.935, 2.973, 2.906, 2.919, 2.910, 3.012, 3.071)
observed.values.3 <- c(0, 1.596, 2.333, 2.611, 2.750, 2.731, 2.829, 2.838,
                       2.864, 2.884, 2.886, 2.911, 2.896, 2.877, 2.969)
observed.processes <- cbind(observed.time, observed.values.1,
                            observed.values.2, observed.values.3)
# fitting the model without any fixed parameters
result <- fit.model.tou(w=observed.processes)
draw.model.tou(result)

}
