% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.to.vector.R
\name{tree.to.vector}
\alias{tree.to.vector}
\title{Phylogenetic tree to vector}
\usage{
tree.to.vector(tree, normalization = TRUE)
}
\arguments{
\item{tree}{phylogenetic tree}

\item{normalization}{logical; normalize the tree if TRUE}
}
\value{
vector of pairwise distances in R^(m choose 2), where m is the number of leaves
}
\description{
A tree is converted to a vector of pairwise distances between leaves.
Distance between leaves is defined as the cophenetic distance between them.
Normalization is applied so that the maximum distance in the vector output is 1.
}
\examples{
tree <- ape::read.tree(text='((A:1, B:1):2, (C:1.5, D:1.5):1.5);')
tree.to.vector(tree)
}
\references{
Aliatimis, Georgios, Ruriko Yoshida, Burak Boyaci, James A. Grant (2023). Tropical Logistic Regression on Space of Phylogenetic Trees
}
\author{
Georgios Aliatimis \email{g.aliatimis@lancaster.ac.uk}
}
