\name{plot.ticm}
\alias{plot.ticm}
\title{Plot Estimated Independent Components from a \code{ticm} Object}
\description{
Produces a scatterplot matrix of the estimated independent components stored in a \code{ticm} object,
typically returned by \code{\link{icm_test}}.
}
\usage{
\method{plot}{ticm}(x, ...)
}
\arguments{
  \item{x}{An object of class \code{ticm}, typically resulting from a call to \code{\link{icm_test}}.}
  \item{...}{Additional graphical parameters passed to \code{\link[graphics]{pairs}} to customize the scatterplot matrix
  (e.g., \code{pch}, \code{cex}, \code{gap}, \code{labels}).}
}
\details{
The function extracts the matrix of estimated independent components from \code{x} (as obtained from the
ICA step within \code{\link{icm_test}}) and displays a scatterplot matrix using \code{\link[graphics]{pairs}}.
This visualization is useful for a quick diagnostic of remaining dependence: under a well-fitting independent
component model, pairwise plots of the estimated components should show little visible structure.

The argument \code{...} is forwarded to \code{pairs}, allowing customization of points, labels, and panel
functions (e.g., adding smoothers or correlations via \code{panel = } or \code{upper.panel = }).
}
\value{
No return value, called for side effects.
}
\seealso{
\code{\link{icm_test}}, \code{\link[graphics]{pairs}}
}
\examples{
n <- 200
X <- cbind(runif(n), rexp(n), rnorm(n))

# in practice, the number of resamples should be much larger
res <- icm_test(X)
plot(res)
}
\keyword{multivariate}
\keyword{plot}
