% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateEnrichement.R
\name{FASTcalculateRC}
\alias{FASTcalculateRC}
\title{calculates Random Control (RC) fastly?}
\usage{
FASTcalculateRC(
  df,
  DEGs,
  catalog,
  TFs,
  all.targets,
  TF.col = "TF..OFFICIAL_TF_CODING_GENE_NAME.",
  lambda = 0.05,
  nRep = 100
)
}
\arguments{
\item{df}{a data frame containng p-values}

\item{DEGs}{a character vector of DEGs (differentially expressed genes)}

\item{catalog}{a data frame of TFactS catalog (ver. 2)}

\item{TFs}{a character vector of transcription factor}

\item{all.targets}{a character vector of all target genes}

\item{TF.col}{the name of the column that contains the TF names}

\item{lambda}{a user-specified threshold of E-value (default: 0.05)}

\item{nRep}{number of random selections (default: 100)}
}
\value{
data.frame
}
\description{
This function calculates Random Control (RC)
}
\examples{
data(example.df)
data(catalog)
data(DEGs)

tftg <- extractTFTG(DEGs, catalog)
TFs <- tftg$TFs
all.targets <- tftg$all.targets

res <- FASTcalculateRC(example.df, DEGs, catalog, TFs, all.targets)

}
\references{
Essaghir A et al. Nucleic Acids Res. 2010 Jun;38(11):e120.
}
\author{
Atsushi Fukushima
}
