% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{predict_rmax}
\alias{predict_rmax}
\title{predict_rmax}
\usage{
predict_rmax(rMax175ms, vMax, TClats)
}
\arguments{
\item{rMax175ms}{Numeric. A vector of radius of 17.5 m/s winds (in km).}

\item{vMax}{Numeric. A vector of maximum wind speeds (m/s).}

\item{TClats}{Numeric. A vector of latitudes of tropical cyclones (in degrees).}
}
\value{
A vector of predicted rmax values (in km).
}
\description{
Predicts the radius of maximum winds (rmax) based on the radius of 17.5 m/s winds
(rMax175ms) using the Chavas and Knaff (2022) model.
}
\examples{
rMax175ms <- c(100, 120, 140)
vMax <- c(50, 55, 60)
TClats <- c(20, 25, 30)
predict_rmax(rMax175ms, vMax, TClats)
}
