% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotPolygon3D}
\alias{plotPolygon3D}
\title{Plot a polygon.}
\usage{
plotPolygon3D(
  pts,
  useShade = TRUE,
  useLines = FALSE,
  usePoints = FALSE,
  useFrame = TRUE,
  ...
)
}
\arguments{
\item{pts}{Vertices.}

\item{useShade}{Plot shade of the polygon.}

\item{useLines}{Plot lines inside the polygon.}

\item{usePoints}{Plot point shapes inside the polygon.}

\item{useFrame}{Plot a frame around the polygon.}

\item{...}{Further arguments passed on the RGL plotting functions. This must be done as
lists (see examples). Currently the following arguments are supported:
\itemize{
\item \code{argsShade}: A list of arguments for \code{\link[rgl:polygon3d]{rgl::polygon3d}} (n > 4 vertices),
\code{\link[rgl:primitives]{rgl::triangles3d()}} (n = 3 vertices) and \code{\link[rgl:primitives]{rgl::quads3d()}} (n = 4 vertices)
if \code{useShade = TRUE}.
\item \code{argsFrame}: A list of arguments for \code{\link[rgl:primitives]{rgl::lines3d}} if \code{useFrame = TRUE}.
\item \code{argsPoints}: A list of arguments for \code{\link[rgl:shade3d]{rgl::shade3d}} if \code{usePoints = TRUE}. It is important
to give a texture using \code{texture}. A texture can be set using \code{\link[=getTexture]{getTexture()}}.
\item \code{argsLines}: A list of arguments for \code{\link[rgl:persp3d]{rgl::persp3d()}} when \code{useLines = TRUE}. Moreover, the list
may contain \code{lines}: number of lines.
}}
}
\value{
Object ids (invisible).
}
\description{
Plot a polygon.
}
\examples{
\donttest{
pts <- data.frame(x = c(1,0,0,0.4), y = c(0,1,0,0.3), z = c(0,0,1,0.3))
pts <- data.frame(x = c(1,0,0), y = c(0,1,0), z = c(0,0,1))

ini3D()
plotPolygon3D(pts)
finalize3D()

ini3D()
plotPolygon3D(pts, argsShade = list(color = "red", alpha = 1))
finalize3D()

ini3D()
plotPolygon3D(pts, useFrame = TRUE, argsShade = list(color = "red", alpha = 0.5),
              argsFrame = list(color = "green"))
finalize3D()

ini3D()
plotPolygon3D(pts, useFrame = TRUE, useLines = TRUE, useShade = TRUE,
              argsShade = list(color = "red", alpha = 0.2),
              argsLines = list(color = "blue"))
finalize3D()

ini3D()
ids <- plotPolygon3D(pts, usePoints = TRUE, useFrame = TRUE,
              argsPoints = list(texture = getTexture(pch = 16, cex = 20)))
finalize3D()
# pop3d(id = ids) # remove object again

# In general you have to finetune size and numbers when you use textures
# Different pch
for (i in 0:3) {
  fname <- getTexture(pch = 15+i, cex = 30)
  ini3D(TRUE)
  plotPolygon3D(pts, usePoints = TRUE, argsPoints = list(texture = fname))
  finalize3D()
}

# Size of pch
for (i in 1:4) {
  fname <- getTexture(pch = 15+i, cex = 10 * i)
  ini3D(TRUE)
  plotPolygon3D(pts, usePoints = TRUE, argsPoints = list(texture = fname))
  finalize3D()
}

# Number of pch
fname <- getTexture(pch = 16, cex = 20)
for (i in 1:4) {
  ini3D(TRUE)
  plotPolygon3D(pts, usePoints = TRUE,
                argsPoints = list(texture = fname, texcoords = rbind(pts$x, pts$y, pts$z)*5*i))
  finalize3D()
}
}
}
