% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_lineup.R
\name{make_lineup_helper_2}
\alias{make_lineup_helper_2}
\title{Assign overpowered entries}
\usage{
make_lineup_helper_2(
  i,
  df_helper,
  in_progress_entries_df,
  events_competed_helper = Events_Competed,
  max_entries_helper = max_entries,
  max_ind_entries_helper = max_ind_entries
)
}
\arguments{
\item{i}{a sequential list of numbers incremented by 1.  Used to index
function.}

\item{df_helper}{a data frame of all times to be entered for a given team.
Must contain column \code{Event} with the same event naming convention as
\code{op_df}, a column with name matching \code{result_col} containing times
or diving scores, and a column called \code{Name} containing athlete names}

\item{in_progress_entries_df}{a data frame containing the output of
\code{make_lineup_helper}, which is the minimum power set of entries}

\item{events_competed_helper}{a list of lists containing all the events a
given athlete is competing in.  Sub-lists are named with the athlete name.}

\item{max_entries_helper}{a numeric value denoting the maximum number of
athletes a team may enter in a given event}

\item{max_ind_entries_helper}{a numeric value denoting the maximum number of
individual events that may be entered by a single athlete}
}
\value{
a data frame containing entries updated to be as powerful as possible
}
\description{
Matches athletes into events again, this time vs. the output of
\code{make_lineup_helper}.  For example if Team A has six breaststrokers at
57.00, 58.00, 59.00 and three 1:00.00s and Team B has three breaststrokers,
all 1:01.00 then following \code{make_lineup_helper} Team A's entries will be
the three 1:00.00s because they're sufficient to win.
}
\details{
Here though Team A's three 1:00.00s will be replaced by their 57.00, 58.00
and 59.00 breaststrokers.  These entries are "overpowered" but better reflect
an actual set of entries.  Not using \code{make_lineup_helper_2} often
results in a team's best athletes not competing
}
