% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_survival_tree.R
\name{plot_survival_tree}
\alias{plot_survival_tree}
\title{Visualize the Fitted Survival Tree}
\usage{
plot_survival_tree(survival_tree, cex = 0.75)
}
\arguments{
\item{survival_tree}{a fitted survival tree object.}

\item{cex}{numeric character expansion factor.}
}
\value{
No return value, called for generating graphical outputs.
}
\description{
Visualize the Fitted Survival Tree
}
\examples{
library(survival)
a_survival_tree<-
  survival_tree(
  survival_outcome=Surv(time,status==2)~1,
  numeric_predictor=~age+ph.ecog+ph.karno+pat.karno+meal.cal,
  factor_predictor=~as.factor(sex),
  data=lung)
plot_survival_tree(a_survival_tree)
}
