% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning.R
\name{standardize_categories}
\alias{standardize_categories}
\title{Standardize categorical values}
\usage{
standardize_categories(data, col, mapping)
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{col}{Character string specifying column name to standardize}

\item{mapping}{Named list or vector mapping old values to new values}
}
\value{
A data.frame with standardized categories
}
\description{
This function standardizes categorical variables by mapping values to standardized categories.
Useful for consolidating different representations of the same category.
}
\examples{
data <- data.frame(gender = c("M", "Male", "F", "Female", "m"))
mapping <- list("M" = "Male", "Male" = "Male", "F" = "Female", "Female" = "Female", "m" = "Male")
clean_data <- standardize_categories(data, "gender", mapping)
}
