% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_canon.R
\name{plot.surveycc}
\alias{plot.surveycc}
\title{Plot cc object}
\usage{
\method{plot}{surveycc}(x, dim1 = 1, dim2 = 2, ...)
}
\arguments{
\item{x}{the survey cc object, produced by [surveycc()]}

\item{dim1, dim2}{determines which canonical variates serve as the horizontal
and vertical axes in the plot. Default is dim1 = 1, dim2 = 2. Must not
exceed total number of canonical variates in survey cc object.}

\item{...}{Not used.}
}
\value{
the plots
}
\description{
Plot cc object
}
\examples{
# PATH example
design_object <-
 survey::svrepdesign(
 id = ~PERSONID,
 weights = ~R01_A_PWGT,
 repweights = "R01_A_PWGT[1-9]+",
 type = "Fay",
 rho = 0.3,
 data=reducedPATHdata,
 mse = TRUE
 )
var.x <- c("R01_AC1022", "R01_AE1022", "R01_AG1022CG")
var.y <- c("R01_AX0075", "R01_AX0076")
howmany <- 2
out <- surveycc(design_object, var.x, var.y, howmany = howmany,
  selection = "ROWS")
plot(out, dim1 = 1, dim2 = 2)

}
