% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidimlasso.R
\name{hidimLasso}
\alias{hidimLasso}
\title{hidimLasso

LASSO for high dimensional data}
\usage{
hidimLasso(m, n, OS, Death, data)
}
\arguments{
\item{m}{Starting column number from where variables of high dimensional data will get selected.}

\item{n}{Ending column number till where variables of high dimensional data will get selected.}

\item{OS}{Column name of survival duration event, a string value. i.e. "os"}

\item{Death}{Column name of survival event, a string value. i.e "death"}

\item{data}{High dimensional data having survival duration, event and various covariates observations}
}
\value{
A list of variables selected by LASSO as predictor variables.
}
\description{
Least Absolute Shrinkage and Selection Operator (LASSO) for High Dimensional Survival data.
}
\details{
'HiDimLasso' allows a user to apply LASSO function on the High Dimensional data and reduce the study
variables to handful number of co-variate which are observed impacting the survival outcomes.

Column of Overall Survival must be named as 'OS' and the column defining the event
must be named as 'Event'.

By default it stores the outcome data in user's current directory.
}
\examples{
##
data(hnscc)
hidimLasso(7,105,OS="os",Death="death",hnscc)
##
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R and OpenBUGS. CRC Press.

Congdon, P. (2014). Applied bayesian modelling (Vol. 595). John Wiley & Sons.

Banerjee, S., Vishwakarma, G. K., & Bhattacharjee, A. (2019). Classification Algorithm for
High Dimensional Protein Markers in Time-course Data. arXiv preprint arXiv:1907.12853.
}
\seealso{
hidimSurvlas hidimSurvbonlas
}
\author{
Atanu Bhattacharjee and Akash Pawar
}
