% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\encoding{UTF-8}
\name{sracpp}
\alias{sracpp}
\title{Compute the sequential rank agreement between k ranked lists}
\usage{
sracpp(rankMat, maxlength, B, cens, type = 0L, epsilon = as.numeric(c(0)))
}
\arguments{
\item{rankMat}{A matrix with k columns corresponding to the k ranked lists. Elements of each column are integers between 1 and the length of the lists}

\item{maxlength}{The maximum depth that are needed XXX}

\item{B}{The number of resamples to use in the presence of censored lists}

\item{cens}{A vector of integer values that}

\item{type}{The type of distance measure to use: 0 (the default) is the variance while 1 is MAD (median absolute deviation)}

\item{epsilon}{A non-negative numeric vector that contains the minimum limit in proportion of lists that must show the item. Defaults to 0. If a single number is provided then the value will be recycles to the number of items.}
}
\value{
A vector of the same length as the rows in rankMat containing the squared (!) sequential rank agreement between the lists for each depth. If the MAD type was chosen then the sequential MAD values are returned
}
\description{
Computes the sequential rank agreement (number of items present in all k lists divided by the current rank) for each rank in the k lists
}
\author{
Claus Ekstrøm <ekstrom@sund.ku.dk>
}
