% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMS_FH_MisSpecification_DHM.R
\name{mspe_PMS_Mis_FH_DHM}
\alias{mspe_PMS_Mis_FH_DHM}
\title{Post model selection MSPE estimation in FH model with mean mis-specification using Datta-Hall-Mandal method. Calculate the post-model selection mspe of Fay-Herriot model with mean mis-specification using Datta-Hall-Mandal method.}
\usage{
mspe_PMS_Mis_FH_DHM(m, p, X, beta1, beta2, A, D, R)
}
\arguments{
\item{m}{number of small areas}

\item{p}{number of fixed model parameters}

\item{X}{covariates}

\item{beta1}{regression coefficients}

\item{beta2}{regression coefficients}

\item{A}{variance of area-specific random effects}

\item{D}{sampling variance}

\item{R}{number of simulation runs}
}
\value{
Par: return estimation of model parameters

MSPE.TRUE.Final: return empirical MSPE of small area predictor

mspe.DHM.Final: return mspe of small area predictor using the Datta-Hall-Mandal method

RB.DHM: return relative bias (RB) of mspe of small area predictor using the Datta-Hall-Mandal method

Rate: return the probability of rejection (nominal level= 0.2)
}
\description{
Post model selection MSPE estimation in FH model with mean mis-specification using Datta-Hall-Mandal method. Calculate the post-model selection mspe of Fay-Herriot model with mean mis-specification using Datta-Hall-Mandal method.
}
\examples{
mspe_PMS_Mis_FH_DHM(20,3,matrix(runif(60,0,1),nrow=20,byrow=TRUE),
c(1,1,1),c(1,1,1),10,2.5,10)

}
