% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPriorMeans.R
\name{GetPriorMeans}
\alias{GetPriorMeans}
\title{Calibrates prior means for Dose Finding Trial}
\usage{
GetPriorMeans(Prior, Dose)
}
\arguments{
\item{Prior}{#Groups X #Doses matrix containing the elicited prior toxicity probabilities at the reference time for each dose and subgroup.}

\item{Dose}{Vector containing standardized doses.}
}
\value{
Returns the a list containing the nonlinear regression model whos parameter estimates will be used as prior means for the SubTITE Design.
}
\description{
Uses the clinician elicited prior reference probabilities for each subgroup and dose to obtain prior means for the Bayesian logistic regression model used in the SubTite trial design.
}
\examples{
##Specify elicited reference toxicity probabilities
Prior = matrix(c(.2,.3,.4,.5,.6,.1,.2,.3,.4,.5,.05,.1,.15,.2,.3),byrow=TRUE,nrow=3)
Dose=sort(rnorm(5))
GetPriorMeans(Prior,Dose)
}
\references{
[1] Chapple and Thall (2017), Subgroup-specific dose finding in phase I clinical trials based on time to toxicity allowing adaptive subgroup combination
}
