% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-GET.R
\docType{methods}
\name{getPrices}
\alias{getPrices}
\alias{getPrices,Strategy-method}
\title{Get price data from \code{Strategy}-object}
\usage{
getPrices(object, from = NULL, until = NULL, which = NULL)

\S4method{getPrices}{Strategy}(object, from = NULL, until = NULL,
  which = NULL)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which prices shall be returned. If \code{NULL}, no restriction is made.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which prices shall be returned. If \code{NULL}, no restriction is made.}

\item{which}{Names or column-number of assets that should be included. If \code{NULL}, all prices are returned.}
}
\description{
Gets the price data of an object of class \code{Strategy} that was used within strategy calculation.
}
\examples{
##Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Get price data from MA(200)-Strategy
getPrices(myStrat.MA, from="2015-01-01", until="2015-12-31")

##End(Not run)
}
