% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{fit_multiple_dist}
\alias{fit_multiple_dist}
\title{Fits Multiple Probability Distributions to several assets/stock prices.}
\usage{
fit_multiple_dist(dist_names, dataframe)
}
\arguments{
\item{dist_names}{a character vector of distribution names to be fitted.}

\item{dataframe}{a dataframe containing the data to be fitted.}
}
\value{
A list of distributions and their corresponding AIC and BIC values.
}
\description{
This function fits multiple probability distributions to a dataframe and calculates the
Akaike Information Criterion (AIC) and Bayesian Information Criterion (BIC) for each distribution and
then returns a data frame of the AIC values for each asset where the column names are the names of the fitted
distributions.
}
\details{
Note that the available distributions are

norm_fit - Normal distribution

t_fit - Student's t-distribution

cauchy_fit - Cauchy distribution

ghd_fit - Generalized hyperbolic distribution

hd_fit - Hyperbolic distribution

sym.ghd_fit - Symmetric generalized hyperbolic distribution

sym.hd_fit - Symmetric hyperbolic distribution

vg_fit - Variance-gamma distribution

sym.vg_fit - Symmetric variance-gamma distribution

nig_fit - Normal-inverse Gaussian distribution

ged_fit - Generalized error distribution

skew.t_fit - Skew Student's t-distribution

skew.normal_fit - Skew normal distribution

skew.ged_fit - Skew generalized error distribution

Also note that the distribution to be fitted from the above list must include the '_fit'.
The function can also fit one distribution to one asset.
}
\examples{

data <- asset_loader(system.file("extdata", package = "StockDistFit"), c("AAPL", "TSLA"), "Close")
fit_multiple_dist(c("norm_fit", "cauchy_fit"), data)


}
\seealso{
\code{\link{asset_loader}}
}
