% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooksplot.R
\name{cooksplot}
\alias{cooksplot}
\title{Plot of standardized residuals vs. leverage with boundaries for unusual cases}
\usage{
cooksplot(mod)
}
\arguments{
\item{mod}{a regression model from lm( )}
}
\value{
A plot showing standardized residuals versus leverage values with boundaries for unusual cases
}
\description{
This function produces an plot of standardized residuals versus leverage values for a regression model.
Horizontal boundaries identify mild or more extreme standardized residuals.
Vertical boundaries identify mild and more severe high leverage points.
Curved boundaries identify mild and more severe values of Cook's D.
}
\details{
The plot shows standardized residuals (vertical) versus leverage values (horizontal) for all cases in a regression model.

Horizontal (blue) boundaries mark standardized residuals beyond  +/- 2 (mild) and +/- 3 (more severe).

Vertical (green) boundaries mark leverage points beyond 2(k+1)/4 (mild) and 3(k+1)/n (more severe), where k= number of predictors.

Curved (red) boundaries for mark influential points beyond 0.5 (mild) and 1.0 (more severe) using Cook's D.

Unusual points are labeled with a case number.
}
\examples{
data(AccordPrice)
mod1=lm(Price~Age,data=AccordPrice)
cooksplot(mod1)

}
