% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SscSrsMean.R
\name{SscSrsMean}
\alias{SscSrsMean}
\title{Sample size calculator for estimation of population mean under SRS}
\usage{
SscSrsMean(CV_known, replace, alpha, re, N, preliminary_sample)
}
\arguments{
\item{CV_known}{Coefficient of variation (CV) of the population is known or unknown. If it is known, then write TRUE otherwise write FALSE.}

\item{replace}{replace=TRUE, if sampling design is SRSWR and replace=FALSE, if sampling design is SRSWOR.}

\item{alpha}{Level of significance value, alpha=0.01 at 1 percent level of significance and alpha=0.05 at 5 percent level of significance.}

\item{re}{Relative error in the estimation of population mean (e.g. 0.1, 0.5).}

\item{N}{Population size. When sampling design is SRSWR, then write NA.}

\item{preliminary_sample}{Values of the study variable for the preliminary sample. When CV of the population is known, then write NA.}
}
\value{
A list with the following components:
\item{Required sample size}{Sample size required for estimation of population mean when population CV is known or unknown.}
\item{Additional sample units to be surveyed}{Additional sample units to be surveyed over the preliminary sample for estimation of population mean when population CV is unknown. If the value of additional sample units to be surveyed is negative, then preliminary sample is considered as the final sample.}
}
\description{
The SscSrsMean function calculates the sample size required for estimation of population mean based upon the availability of prior information on coefficient of variation (CV) of the population under Simple Random Sampling (SRS) with or without replacement sampling design for a given confidence level and relative error. Further, the function provides the required sample size when population CV is known whereas it provides both required sample size and additional sample units to be surveyed when population CV is unknown under both SRS with or without replacement.
}
\details{
This function returns the sample size required for estimation of population mean when population CV is known. Besides this, the function returns both required sample size and additional sample units to be surveyed when population CV is unknown under both SRS with or without replacement sampling design.
}
\examples{
# Calculate sample size for SRSWOR design when population CV is known
SscSrsMean(TRUE, FALSE, 0.05, 0.2, 100, NA)
# Calculate sample size for SRSWOR design when population CV is unknown
preliminary_sample =c(12, 14, 8, 5, 36, 24, 18, 17, 6, 9)
SscSrsMean(FALSE, FALSE, 0.05, 0.2, 100, preliminary_sample)
# Calculate sample size for SRSWR design when population CV is known
SscSrsMean(TRUE, TRUE, 0.05, 0.2, NA, NA)
# Calculate sample size for SRSWR design when population CV is unknown
preliminary_sample =c(12, 14, 8, 5, 36, 24, 18, 17, 6, 9)
SscSrsMean(FALSE, TRUE, 0.05, 0.2, NA, preliminary_sample)
}
\references{
Cochran, W. G. (1977). \emph{Sampling Techniques, 3rd Edition}. New York: John Wiley & Sons, Inc.

Singh, D. and Chaudhary, F.S. (1986). \emph{Theory and Analysis of Sample Survey Designs}. New York: John Wiley & Sons, Inc.

Sukhatme, P.V., Sukhatme, B.V., Sukhatme, S. and Asok, C. (1984). \emph{Sampling Theory of Surveys with Applications}. Iowa State University Press, Ames and Indian Society of Agricultural Statistics, New Delhi.
}
