% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatPCA.R
\name{plot.spatpca}
\alias{plot.spatpca}
\title{Display the cross-validation results}
\usage{
\method{plot}{spatpca}(x, ...)
}
\arguments{
\item{x}{An spatpca class object for \code{plot} method}

\item{...}{Not used directly}
}
\value{
\code{NULL}.
}
\description{
Display the M-fold cross-validation results
}
\examples{
x_1D <- as.matrix(seq(-5, 5, length = 10))
Phi_1D <- exp(-x_1D^2) / norm(exp(-x_1D^2), "F")
set.seed(1234)
Y_1D <- rnorm(n = 100, sd = 3) \%*\% t(Phi_1D) + matrix(rnorm(n = 100 * 10), 100, 10)
cv_1D <- spatpca(x = x_1D, Y = Y_1D)
plot(cv_1D)
}
\seealso{
\link{spatpca}
}
